#include <iostream>
using std::cin;
using std::cout;
using std::endl;
#include <string>
using std::string;
#include <list>
using std::list;

struct Category{
    Category(string name="", string yesOrNoQuestion=""):
        name(name), yesOrNoQuestion(yesOrNoQuestion) {}
    string name;
    string yesOrNoQuestion;
    list <Category> subcategories;
};

Category top;

void initializeTop() {
    top.subcategories.push_back(Category(
        "Animal","Is it an animal?"));
    top.subcategories.push_back(Category(
        "Vegetable","Is it a vegetable?"));
    top.subcategories.push_back(Category(
        "Mineral","Is it a mineral?"));
}
    
bool answerIsYes() {
    string yesno;
    cin >> yesno;
    return yesno[0] == 'Y' || yesno[0] == 'y';
}

void getStringFromUser(string prompt, string &answer) {
    bool userIsSure = false;
    while (!userIsSure) {
        answer = "";
        cout << prompt << endl;
        while (answer == "") {
            getline(cin,answer);
        }
        cout << "Your answer is \"" << answer << "\"." 
                << endl;
        cout << "Are you sure this is what you want? (y/n) ";
        userIsSure = answerIsYes();
    }
}

void addNewSubcategory(Category &category) {
    string namePrompt = 
        "Please enter the name of a new subcategory of " +
        category.name + ".";
    Category newSubcategory;
    getStringFromUser(namePrompt, newSubcategory.name);
    string questionPrompt = 
        string("Please enter a yes or no question by which we ") + 
        "can identify a " + newSubcategory.name + ".";
    getStringFromUser(
        questionPrompt, newSubcategory.yesOrNoQuestion);
    category.subcategories.push_back(newSubcategory);
}

void converseWithUser(Category &category, 
                        list<Category>::iterator nextTry) {
    if (nextTry == category.subcategories.begin() && 
        category.name != "")
        cout << "The answer is '" << category.name << "'." 
                << endl;
    if (nextTry != category.subcategories.end()) {
        cout << nextTry->yesOrNoQuestion << " (y/n) ";
        if (answerIsYes()) 
            converseWithUser(
                *nextTry, nextTry->subcategories.begin());
        else converseWithUser(category, ++nextTry);
    }
    else if (category.name != "") {
        cout << "Would you like to further identify the "
                << "type of " << category.name << "? (y/n) ";
        if (answerIsYes()) addNewSubcategory(category);
    }
    else
        cout << "You must choose animal, vegetable, or "
                << "mineral!" << endl;
}

typedef int (&rifii) (int, int);
int f(int x, int y) { return x+y; }
int g(int x, int y) { return x*y; }

int main() {
	rifii rf = g;
	cout << rf(5,6) << endl;
	return 0;
    initializeTop();
    bool userStillPlaying = true;
    while (userStillPlaying) {
        converseWithUser(top,top.subcategories.begin());
        cout << "Try another game? (y/n) ";
        userStillPlaying = answerIsYes();
    }
    return 0;
}
